<?php if($is_comment == 1){ ?>
<?php if(statusModule('communication', 'comments') == 1  && statusModule('users', 'clients') == 1){ ?>
    <section id="comments" class="mt-4">
        <h2 class="mb-3 title"><?php echo $_LANG['comments']; ?> (<?php echo $countComment; ?>)</h2>
        
        <div class="text-center mb-4">
            <?php if($clientId){ ?>
                <div class="card">
                    <div class="card-body">
                        <form id="comment-form" method="post" class="no-ajaxy ">
                            <div class="form-floating mb-3">
                                <textarea class="form-control" name="comment" id="comment" style="height: 100px" placeholder="<?php echo $_LANG['write_your_comment'] ?>" required="" maxlength="500"></textarea>
                                <label for="comment" class="form-label"><?php echo $_LANG['write_your_comment'] ?></label>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="submit btn btn-primary"><?php echo $_LANG['publish_btn']; ?></button>
                                <button class="loading btn btn-primary d-none" type="button" disabled="">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    <span class="visually-hidden"><?php echo $_LANG['loading']; ?></span>
                                </button>
                                <span id="res-message" class="d-block mt-2"></span>  
                            </div>
                            <input type="hidden" name="module" value="<?php echo $page1; ?>">
                            <input type="hidden" name="post_id" value="<?php echo $item->postId; ?>">
                        </form>
                    </div>
                </div>
            <?php }else{ ?>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalLogin"><?php echo $_LANG['make_your_comment']; ?></button>
            <?php } ?>
        </div>
        
        <span id="append-comment"></span>
        <?php if($commentList){ ?>
            <?php foreach($commentList as $comment){ ?>
            <div class="comment mb-3">
                <div class="me-3">
                    <img class="avatar rounded-circle" loading="lazy" src="<?php echo PATH_SYSTEM; ?>public/avatar/<?php echo $comment->avatar; ?>" alt="<?php echo $comment->full_name; ?>">
                </div>
                <div class="card w-100">
                    <div class="p-3">
                        <span class="author"><?php echo $comment->full_name; ?></span>
                        <p class="mb-1"><?php echo $comment->comment; ?></p>
                        <small class="text-muted float-end"><?php echo elapsedTime($comment->date_post); ?></small>
                    </div>
                </div>
            </div>
            <?php } ?>
            <?php echo pagination($pathPage, $countComment, $perPage, $currentPage, null, '#comments'); ?>
        <?php } ?>
    </section>
<?php } ?>
<?php } ?>